MObject->Fields (
  container   => {noset => 1, noinherit => 1},
  contents    => {noset => 1, noinherit => 1, default => []},
);

MObject->Methods (
add_contents => sub {
  my ($self, @objs) = @_;
  
  foreach my $obj (@objs) {
    ref $obj or cluck("add_contents called with non_object"), return;
    if (my $objc = $obj->container) {
      $objc->remove_contents($obj);
    }
    $obj->container(MObjectRef->new($self->id));
    $self->localize_field('contents');
    push @{$self->contents}, MObjectRef->new($obj->id);
  }
},

remove_contents => sub {
  my ($self, @remove) = @_;

  my %remove = map {$_->id, 1} @remove;
  $self->localize_field('contents');
  my $clist = $self->contents;
  
  for (my $i = 0; $i < @$clist; $i++) {
    next unless $remove{(my $obj = $clist->[$i])->id};
    $obj->reset_val('container');
    splice @$clist, $i--, 1;
    # $i decremented since the indices change due to splicing the array
  }
},

move_into => sub {
  my ($self, $dest) = @_;

  defined $dest or do {$self->container->remove_contents($self); return};
  $dest->is_inside($self) and croak "can't move #".$self->id." into #".$dest->id.": would cause containership loop";

  my $self_container = $self->container;
  my $dest_container = $dest->container;
  my $dolook = (!$self_container or ($self_container != $dest and (!$dest_container or $dest_container != $self_container)));

  # FIXME: reenable weight change notification using a watcher or impulse mechanism
  # my $selfweight = $self->total_weight;
  # $self->send_impulse(type => 'notify.weight_change', info => {delta => -$selfweight});

  $dest->add_contents($self);

  # $self->send_impulse(type => 'notify.weight_change', info => {delta => $selfweight});
  
  if ($dolook) {
    $self->do('look BRIEF');
    foreach (@{$self->contents}) {
      $_->do('look BRIEF');
    }
  }
},

is_inside => sub {
  my ($inner, $outer) = @_;
  while ($inner) {
    return 1 if $inner == $outer;
    $inner = $inner->container;
  }
  return 0;
},

);

MObject->Commands (
);

Hooks (
  'object_destruction' => sub {
    my ($self) = @_;
    if (my $con = $self->contents) {
      foreach (@$con) {
        next unless ref $_;
        $_->container(undef);
      }
      if ($self->container) {
        $self->container->add_contents(@$con);
      } else {
        foreach (@$con) {
          $_->dispose if ref $_;
        }
      }
      $self->reset_val('contents');
    }
    { ($self->container or last)->remove_contents($self); }
  },
);
